import java.util.Hashtable;

// Referenced classes of package duggelz.jape:
//            Field

public class ChoiceField
    implements Field
{

    public ChoiceField(Field baseField, Hashtable table)
    {
        this.baseField = baseField;
        this.table = table;
    }

    public String get(byte data[])
    {
        int value = baseField.getInt(data);
        String str = (String)table.get(new Integer(value));
        return str;
    }

    public int getInt(byte data[])
    {
        int value = baseField.getInt(data);
        return value;
    }

    public void set(byte data[], String str)
        throws NumberFormatException
    {
        Integer val = (Integer)table.get(str);
        if(val == null)
        {
            return;
        } else
        {
            int value = val.intValue();
            setInt(data, value);
            return;
        }
    }

    public void setInt(byte data[], int value)
        throws NumberFormatException
    {
        baseField.setInt(data, value);
    }

    private Field baseField;
    private Hashtable table;
    static final long serialVersionUID = 030265;
}